package w83a.w83aOperacionesPaso.w83aPreavisos;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.JSONArray;
import org.json.JSONObject;

import w83a.w83aBeans.W83aDocBean;
import w83a.w83aBeans.W83aImpugnacionesBean;
import w83a.w83aBeans.W83aPreavisosBean;
import w83a.w83aBeans.W83aUsuarioXLNetsBean;
import w83a.w83aUtilidades.W83aUtilidadesComunes;
import w83a.w83aUtilidadesComunes.W83aClsConstantes;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

public class W83aDetallesPreavisoOutOPAction extends Q70ActionPasoOP{

	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		//Guardamos la accion en el contexto
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		HashMap mapa = (HashMap)contexto.get("w83aMapaPreavisos");
		if ("0".equals(mapa.get("pestania"))){
			W83aPreavisosBean preaviso=(W83aPreavisosBean)contexto.get("w83aPreavisosNuevoBean");
			contexto.set("w83aprovincia", preaviso.getCentroTrabajo().getCodTerritorio());
			contexto.set("w83amunicipio", preaviso.getCentroTrabajo().getCodMunicipio());
			contexto.set("w83aprovincia_alt", preaviso.getIdProvincia_alt());
			contexto.set("w83amunicipio_alt", preaviso.getCodMunicipio_alt());
			W83aUsuarioXLNetsBean usuario= (W83aUsuarioXLNetsBean)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
			//contexto.set("w83aPerfilUsuario", W83aUtilidadesN38API.elegirAdministradorConsulta(usuario.getPerfilXLNets()));
			//contexto.set("w83aCodTerritUsuario", W83aUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets()));
			contexto.set("w83aCodTerritUsuario", usuario.getCodTerritorioDelegacion());
			//contexto.set("w83aRegManual", usuario.getRegManual());
			contexto.set("w83aPreavisosNuevoBeanTemp", preaviso);
			return mapping.findForward("paginaDetalles");
		}else{
			JSONObject resultado = new JSONObject ();
			
			if ("1".equals(mapa.get("pestania"))){
				//preaviso original
				W83aPreavisosBean preavisoOriginal=(W83aPreavisosBean)contexto.get("w83aPreavisosNuevoBean");
				resultado.put("cif", preavisoOriginal.getCentroTrabajo().getCifnif());
				resultado.put("numCentro", preavisoOriginal.getCentroTrabajo().getNumCentro());
				resultado.put("razonSocial", preavisoOriginal.getCentroTrabajo().getRazonSocial());
				resultado.put("codTerritorio", preavisoOriginal.getCentroTrabajo().getCodTerritorio());
				resultado.put("territorio", preavisoOriginal.getCentroTrabajo().getTerritorio());
				resultado.put("codMunicipio", preavisoOriginal.getCentroTrabajo().getCodMunicipio());
				resultado.put("municipio", preavisoOriginal.getCentroTrabajo().getMunicipio());
				resultado.put("fechaEntrada",preavisoOriginal.getFecha_entrada());
				resultado.put("fechaInicio",preavisoOriginal.getFecha_inicio());
				resultado.put("numRegistro",preavisoOriginal.getNum_registro());
				resultado.put("fechaRegistro",preavisoOriginal.getFecha_entrada());
				resultado.put("codConvenio",preavisoOriginal.getCodConvenio());
				resultado.put("descConvenio",preavisoOriginal.getDescConvenio());
				resultado.put("eParcial",preavisoOriginal.getEleccion_parcial());
				resultado.put("prevGlobal",preavisoOriginal.getPreaviso_global());
				resultado.put("admon",preavisoOriginal.getAdmon());
				resultado.put("empresa",preavisoOriginal.getAdmon());
				resultado.put("numtrabajadores",preavisoOriginal.getCentroTrabajo().getNumTrabajadores());
				resultado.put("numcentrosafectados",preavisoOriginal.getNum_centros_afectados());
				resultado.put("fechaEleccion",preavisoOriginal.getFecha_eleccion());
				resultado.put("codTerritActa",preavisoOriginal.getCodterrit_acta());
				resultado.put("anyoActa",preavisoOriginal.getAnyo_acta());
				resultado.put("numActa",preavisoOriginal.getNum_acta());
				resultado.put("idProvincia_alt",preavisoOriginal.getIdProvincia_alt());
				resultado.put("codMunicipio_alt",preavisoOriginal.getCodMunicipio_alt());
				resultado.put("dirAlternativa",preavisoOriginal.getDirAlternativa());
				resultado.put("codPostalAlternativa",preavisoOriginal.getCodPostalAlternativa());
				resultado.put("observaciones",preavisoOriginal.getObservaciones());
				resultado.put("codPromotores",preavisoOriginal.getCodsPromotores());
				resultado.put("descPromotores",preavisoOriginal.getPromotores_desc());
				resultado.put("cnaePreavisoOriginal",preavisoOriginal.getCnaePreavisoOriginal());
				resultado.put("desccnae",preavisoOriginal.getDesccnaePreavisoOriginal());
				resultado.put("telefonoPreavisoOriginal",preavisoOriginal.getTelefonoPreavisoOriginal());
				resultado.put("faxPreavisoOriginal",preavisoOriginal.getFaxPreavisoOriginal());
				resultado.put("emailPreavisoOriginal",preavisoOriginal.getEmailPreavisoOriginal());
				resultado.put("numtrabPreavisoOriginal",preavisoOriginal.getNumTrabPreavisoOriginal());
				resultado.put("territsegsocialPreavisoOriginal",preavisoOriginal.getTerritssPreavisoOriginal());
				resultado.put("numsegsocialPreavisoOriginal",preavisoOriginal.getNumssPreavisoOriginal());
				resultado.put("digsegsocialPreavisoOriginal",preavisoOriginal.getDigcontssPreavisoOriginal());
				resultado.put("fechaRegistroESPreavisoOriginal",preavisoOriginal.getFechaRegistroESPreavisoOriginal());
				resultado.put("numRegistroESPreavisoOriginal",preavisoOriginal.getNumRegistroESPreavisoOriginal());
				
				
				resultado.put("resultado", "ok");
				response.setContentType("text/javascript;charset=iso-8859-1");
				response.setHeader("Pragma", "cache");
				response.setHeader("Expires", "0");
				response.setHeader("Cache-Control", "private");
				response.setStatus(HttpServletResponse.SC_OK);
				PrintWriter out = response.getWriter();
				out.print(resultado.toString());
				out.flush();
				
				return null;
		
			}else if ("2".equals(mapa.get("pestania")))	{
					//docs adjuntos
					W83aPreavisosBean preaviso=(W83aPreavisosBean)contexto.get("w83aPreavisosNuevoBean");
					JSONArray listaDocs=new JSONArray();
					JSONObject docJSON=null;
					W83aDocBean doc=null;
					for (int i=0;i<preaviso.getListaDocs().size();i++)
					{
						doc=(W83aDocBean)preaviso.getListaDocs().get(i);
						docJSON=new JSONObject();//NOPMD
						docJSON.put("nombreDoc", doc.getNombrePartido());
						docJSON.put("tipoDoc", doc.getTipoDocumento());
						if (W83aClsConstantes.CONSTANTE_CASTELLANO.equals(preaviso.getIdioma()))
						{
							docJSON.put("descTipo", doc.getDescTipo());
							docJSON.put("descTramite", doc.getDescTramite());

						}
						else
						{
							docJSON.put("descTipo", doc.getDeseTipo());
							docJSON.put("descTramite", doc.getDeseTramite());

						}
						docJSON.put("idDoc", doc.getId());
						String numRegistro = "";
						String fechaRegistro = "";
						if(StringUtils.isNotEmpty(doc.getNumeroRegistro())){
							numRegistro = doc.getNumeroRegistro();
						}
						if(StringUtils.isNotEmpty(doc.getFechaRegistro())){
							fechaRegistro = doc.getFechaRegistro();
						}
						docJSON.put("numRegistro", numRegistro);
						docJSON.put("fechaRegistro", fechaRegistro);
						docJSON.put("usuario", doc.getUsuario());
						listaDocs.put(docJSON);

					}
					resultado.put("listaDocs",listaDocs);
					
					resultado.put("resultado", "ok");
					response.setContentType("text/javascript;charset=iso-8859-1");
					response.setHeader("Pragma", "cache");
					response.setHeader("Expires", "0");
					response.setHeader("Cache-Control", "private");
					response.setStatus(HttpServletResponse.SC_OK);
					PrintWriter out = response.getWriter();
					out.print(resultado.toString());
					out.flush();
					
					return null;

				}
				else
					if ("3".equals(mapa.get("pestania")))
					{
						//impugnaciones
						W83aPreavisosBean preaviso=(W83aPreavisosBean)contexto.get("w83aPreavisosNuevoBean");
						W83aImpugnacionesBean impugnacionBean=new W83aImpugnacionesBean();
						impugnacionBean = (W83aImpugnacionesBean)W83aUtilidadesComunes.inicializarPaginador(request, impugnacionBean);
						int num_paginas = (preaviso.getListaImpugnaciones().size()/Integer.parseInt(impugnacionBean.getTotal()));
						
						W83aPreavisosBean preavisoTemp=(W83aPreavisosBean)contexto.get("w83aPreavisosNuevoBeanTemp");
						List listaImpugnaciones = new ArrayList();
						for(int i=0,size=preaviso.getListaImpugnaciones().size();i<size;i++){
							W83aImpugnacionesBean bean = new W83aImpugnacionesBean((W83aImpugnacionesBean)preaviso.getListaImpugnaciones().get(i));//NOPMD
							
							listaImpugnaciones.add(bean);
						}
						preavisoTemp.setListaImpugnaciones(listaImpugnaciones);
						contexto.set("w83aPreavisosNuevoBeanTemp",preavisoTemp);
						
						if(preaviso.getListaImpugnaciones().size()%Integer.parseInt(impugnacionBean.getTotal())>0){
							num_paginas++;
						}
						impugnacionBean.setRows(String.valueOf(num_paginas));
						
						
						List listaVariables = new ArrayList();
						
						listaVariables.add("num_impugnacion");
						listaVariables.add("fecha_impugnacion");
						listaVariables.add("tipo");
						listaVariables.add("impugnante");
						listaVariables.add("sindicatos");
						listaVariables.add("dni_arbitro");
						listaVariables.add("nombre_arbitro");
						listaVariables.add("num_laudo");
						listaVariables.add("fech_laudo");
						listaVariables.add("fech_envio_juzgado");
						listaVariables.add("fech_sentencia");
						listaVariables.add("fech_baja_desest");
						listaVariables.add("resultado");
						String varClave = "num_impugnacion";
						
						
						String jJson = W83aUtilidadesComunes.procesarTablaConId(preaviso.getListaImpugnaciones(),listaVariables,varClave,W83aImpugnacionesBean.class, impugnacionBean);
						
						response.setContentType("text/javascript;charset=iso-8859-1");
						response.setHeader("Pragma", "cache");
						response.setHeader("Expires", "0");
						response.setHeader("Cache-Control", "private");
						response.setStatus(HttpServletResponse.SC_OK);
						PrintWriter out = response.getWriter();
						out.print(jJson);
						out.flush();
					}
			return null;
		}
		
	}
}
